#!/bin/bash
#============================================
#脚本名称： mgr_cluster_deployment01.sh
#脚本作者：     WHao
#脚本版本：     v0.1
#创建时间：   2025-05-17
#脚本用途：mysql数据库MGR高可用集群部署脚本01
#============================================
#MGR集群用户：rpl_user
#MGR集群用户密码：QWERqwer


#颜色变量
R='\033[0;31m'  # 红色
G='\033[0;32m'  # 绿色
W='\e[0m'     # 恢复默认


# 从配置文件中读取变量
source /tmp/mgr_cluster_config.env

# 将 SLAVE_IPS 字符串转为数组
IFS=' ' read -r -a slave_ips <<< "$SLAVE_IPS"

# 此处可直接使用：$MASTER_IP 和 ${slave_ips[@]}


#安装MySQL服务软件
for ip in ${slave_ips[@]};do
    if ssh root@$ip 'command -v yum' &> /dev/null; then
        echo "[$ip] 检测到 yum，开始安装 mysql-server"
        ssh root@$ip 'yum install -y mysql-server' &> /dev/null
    elif ssh root@$ip 'command -v apt' &> /dev/null; then
        echo "[$ip] 检测到 apt，开始安装 mysql-server"
        ssh root@$ip 'apt update && apt install -y mysql-server' &> /dev/null
    else
         echo "[$ip] 未找到 yum 或 apt，跳过" >&2
    fi

    echo "[$ip]设置mysql开启自启中..."
    ssh root@$ip 'systemctl enable --now mysqld.service'

done

    
#设置用户认证策略文件
echo "ALTER USER 'root'@'localhost' IDENTIFIED BY '123456';" > mysql_user.sql
  for ip in ${slave_ips[@]};do
    scp mysql_user.sql root@$ip:
    ssh root@$ip "mysql -e 'source /root/mysql_user.sql;'" ;done

#加载组复制模块
echo "master 节点组复制模块加载中...."
ssh root@"${slave_ips[0]}" \
  "mysql -uroot -p'123456' -e \"INSTALL PLUGIN group_replication SONAME 'group_replication.so';\""


#提取IP地址最后一位为server-id
declare -A server_ids
for ip in "${slave_ips[@]}"; do
  server_ids[$ip]=${ip##*.};
done


#设置组ip
gr_seeds=()
for ip in "${slave_ips[@]}"; do
  gr_seeds+=("${ip}:33061")
done
IFS=, read -r -a _ <<< "${gr_seeds[*]}"
group_seeds="${gr_seeds[*]}"
group_seeds=${group_seeds// /,}

#设置集群UUID
cluster_uuid=$(uuidgen)



#设置配置文件
for ip in ${slave_ips[@]};do
  if ssh root@$ip 'command -v yum' &> /dev/null; then
      ssh root@$ip "cp /etc/my.cnf.d/mysql-server.cnf{,.bak}"
        echo "原配置文件已备份"
        echo "$ip 新配置文件写入中..."
        ssh root@$ip  "
        cat >> /etc/my.cnf.d/mysql-server.cnf <<- eof
default_authentication_plugin=mysql_native_password
plugin_dir=/usr/lib64/mysql/plugin
server_id=${server_ids[$ip]}
gtid_mode=ON
enforce_gtid_consistency=ON
binlog_checksum=NONE

log_bin=binlog
log_slave_updates=ON
binlog_format=ROW
master_info_repository=TABLE
#relay_log_infor_repository=TABLE
#从 8.0.23 版本开始，该变量必须被省略

transaction_write_set_extraction=XXHASH64
plugin_load_add='group_replication.so'
group_replication_group_name=$cluster_uuid
group_replication_start_on_boot=off
group_replication_local_address=${ip}:33061
group_replication_group_seeds=${group_seeds}
group_replication_bootstrap_group=off
report_host=${ip}
report_port=3306
eof
"
  ssh root@$ip "systemctl restart mysqld"
  echo "$ip mysql 配置文件已更新...."

  else 
    echo "本脚本暂不支持Debian系统"
  fi
done




#设定MGR集群认证脚本


echo "SET SQL_LOG_BIN=0;
CREATE USER rpl_user@'%' IDENTIFIED BY 'QWERqwer';
GRANT REPLICATION SLAVE ON *.* TO rpl_user@'%';
GRANT CONNECTION_ADMIN ON *.* TO rpl_user@'%';
GRANT BACKUP_ADMIN ON *.* TO rpl_user@'%';
GRANT GROUP_REPLICATION_STREAM ON *.* TO rpl_user@'%';
CREATE USER 'remote'@'%' IDENTIFIED WITH mysql_native_password BY 'QWERqwer';
GRANT all privileges ON *.* TO remote@'%';
FLUSH PRIVILEGES;
SET SQL_LOG_BIN=1;
RESET MASTER;
" > cluster_auth_init.sql



#执行集群认证脚本
for ip in ${slave_ips[@]};do
  scp cluster_auth_init.sql root@$ip:
  ssh root@$ip "mysql -uroot -p123456 < /root/cluster_auth_init.sql "
  echo "集群认证成功...."
done


#master节点设置集群环境
#识别安装mysql版本
#MYSQL_VERSION=$(mysql -V | awk '{print $3}' | awk -F. '{print $1"."$2"."$3}')
#VERSION_NUM=$(echo $MYSQL_VERSION | awk -F. '{printf "%d%02d%02d", $1,$2,$3}')

#echo "SET GLOBAL group_replication_bootstrap_group=ON;
#START GROUP_REPLICATION
#SET GLOBAL group_replication_bootstrap_group=OFF;
#" > master_before_8_0_21.sql

echo "SET GLOBAL group_replication_bootstrap_group=ON;
START GROUP_REPLICATION USER='rpl_user', PASSWORD='QWERqwer';
SET GLOBAL group_replication_bootstrap_group=OFF;
" > master_after_8_0_21.sql

#判断版本执行对应的文件
#if [ $VERSION_NUM -lt 8021 ]; then
#    scp master_before_8_0_21.sql root@${slave_ips[0]}:
#    ssh root@${slave_ips[0]} "mysql -uroot -p123456 < /root/master_before_8_0_21.sql"
#else
    scp master_after_8_0_21.sql root@${slave_ips[0]}:
    echo "master 节点加入MGR集群...."
    ssh root@${slave_ips[0]} "mysql -uroot -p123456 < /root/master_after_8_0_21.sql"
#fi




#slave 节点加入集群
echo "CHANGE REPLICATION SOURCE TO SOURCE_USER='rpl_user',SOURCE_PASSWORD='QWERqwer' FOR CHANNEL 'group_replication_recovery';
START GROUP_REPLICATION USER='rpl_user', PASSWORD='QWERqwer';
" > slave_after_8.0.21.sql

for ip in ${slave_ips[*]:1};do

  scp slave_after_8.0.21.sql root@$ip:
  echo "slave 节点加入MGR集群中...."
  ssh root@$ip "mysql -uroot -p123456 < /root/slave_after_8.0.21.sql"

done



echo -e "$R================MYSQL数据库MGR集群部署完毕================================$W"
echo -e "$G MGR集群  master 节点：${slave_ips[0]}                       "
echo -e "$G MGR集群  slave  节点: ${slave_ips[*]:1}                     "
echo -e "$G MYSQL  root 用户密码:  123456  (后续可更改)                 "
echo -e "$G MGR rpl_user用户密码:  脚本01中备注                         "
echo -e "$R==========================================================================$W"


sleep 2

/bin/bash mgr_mode_switching.sh


















