#!/bin/bash
#==========================================
#脚本名称： mgr_cluster_deployment00.sh
#脚本作者：     WHao
#脚本版本：	v0.1
#创建时间： 2025-05-17 20:30:59
#脚本用途：mysql数据库MGR高可用集群部署脚本
#=========================================

#颜色变量
R='\033[0;31m'  # 红色
G='\033[0;32m'  # 绿色
Y='\033[0;33m'  # 黄色
W='\e[0m'     # 恢复默认


clear
#欢迎信息
echo -e "$R======================================================$W"
echo -e "$R 	     mysql数据库MGR高可用集群部署脚本	"
echo -e "$R======================================================$W"
echo -e "脚本仅支持IPV4地址"
read -p "请输入需要部署集群的MASTER节点IP: " masterip

until [[ "$slavenum" =~ ^[2-9]$ ]]; do
    read -p "请输入集群SLAVE节点主机数量(2-9): " slavenum
    if ! [[ "$slavenum" =~ ^[2-9]$ ]]; then
        echo -e "错误: 请输入有效的数字!"
    fi
done

slave_ips=("$masterip")
echo -e "$R请依次输入$slavenum个SLAVE节点IP:$W"
for ((i=1; i<=$slavenum; i++)); do
    read -p "请输入SLAVE节点$i的IP: " ip
    slave_ips+=("$ip")
done

# 验证所有IP格式
all_valid=true
for ip in "$masterip" "${slave_ips[@]}"; do
    if ! [[ "$ip" =~ ^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$ ]]; then
        echo -e "$R错误: $ip 不是有效的IPv4地址!$W"
        all_valid=false
    fi
done

echo -e "$R=================集群IP地址信息=======================$W"
echo -e "$G主节点IP: $masterip"
echo -e "$G从节点IP列表: ${slave_ips[*]:1}"
echo -e "$R======================================================$W"
echo -e "开始搭建主机免密通信......"
sleep 2

SSH_PASS="123456"
SSH_USER="root"
SSH_PORT=22

# 检查并安装 sshpass（适用于CentOS/RHEL系和Debian/Ubuntu系）
if ! command -v sshpass &> /dev/null; then
    echo -e "${Y}sshpass 未安装，正在尝试安装...${W}"
    if command -v yum &> /dev/null; then
	echo "正在下载sshpass..."
        yum install -y sshpass &> /dev/null
    elif command -v apt &> /dev/null; then
	echo "正在下载sshpass..."
        apt update && apt install -y sshpass &> /dev/null
    else
        echo -e "${R}错误：无法检测到支持的包管理器来安装 sshpass${W}"
        exit 1
    fi
fi

# 生成 SSH 密钥（如果不存在）
[ ! -f ~/.ssh/id_rsa ] && ssh-keygen -t rsa -N "" -f ~/.ssh/id_rsa

# 提前收集所有主机的公钥，避免交互确认
for ip in "${slave_ips[@]}"; do
    ssh-keyscan -p $SSH_PORT $ip >> ~/.ssh/known_hosts 2>/dev/null
done

# 使用 sshpass 配置免密登录
for ip in "${slave_ips[@]}"; do
    echo -e "正在为 $ip 配置免密登录..."
    sshpass -p "$SSH_PASS" ssh-copy-id -p $SSH_PORT -o StrictHostKeyChecking=no $SSH_USER@$ip
    sshpass -p "$SSH_PASS" ssh -p $SSH_PORT -o StrictHostKeyChecking=no $SSH_USER@$ip "echo '成功连接到 $ip!'"
done

echo -e "${G}所有节点 SSH 免密登录配置完成！${W}"


#检查主机selinux是否开启
echo -e "${Y}检查并关闭各节点 SELinux...${W}"
for ip in "${slave_ips[@]}"; do
    echo "[$ip] 正在处理..."
    ssh -p $SSH_PORT root@"$ip" '
        if [ "$(getenforce)" != "Disabled" ]; then
            setenforce 0
            sed -i "s/^SELINUX=.*/SELINUX=disabled/" /etc/selinux/config
            echo "SELinux 已关闭并设置为永久关闭。"
        else
            echo "SELinux 已关闭。"
        fi
    '
done
    echo -e "${G}SELinux 配置完成！${W}"

#设置各主机时间同步
echo -e "${Y}时间同步…${W}"
for ip in "${slave_ips[@]}"; do
  ssh -p $SSH_PORT root@"$ip" '
    (command -v chronyd || { (yum -y install chrony 2>/dev/null || { apt -y update; apt -y install chrony; }); }); 
    systemctl enable --now chronyd;
    chronyc -a makestep
  ' &
done
wait
    echo -e "${G}chrony 配置并已强制校时完成${W}"

#设置防火墙禁用
echo -e "${Y}设置防火墙禁用中...${W}"
for ip in "${slave_ips[@]}"; do
  ssh -p $SSH_PORT root@"$ip" systemctl disable --now firewalld; nft flush ruleset
done

# 保存 IP 信息到配置文件
CONFIG_FILE="/tmp/mgr_cluster_config.env"
    echo "MASTER_IP=$masterip" > "$CONFIG_FILE"
    echo "SLAVE_IPS=\"${slave_ips[*]}\"" >> "$CONFIG_FILE"

# 执行下一个脚本
/bin/bash mgr_cluster_deployment01.sh


